/*
 * Decompiled with CFR 0.152.
 */
package com.bosschongsheng.client;

import com.bosschongsheng.client.RulePickerScreen;
import com.bosschongsheng.config.BossRespawnConfigClient;
import com.bosschongsheng.network.PacketReloadBossRules;
import com.bosschongsheng.network.PacketRemoveBossRule;
import com.bosschongsheng.network.PacketRequestConfig;
import com.bosschongsheng.network.PacketSaveBossRules;
import com.bosschongsheng.network.XiangcaoNet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class BossRespawnConfigScreen
extends Screen {
    private static final int PAD = 10;
    private static final int ROW_H = 24;
    private static final int TITLE_H = 20;
    private static final int SEARCH_H = 20;
    private static final int FOOTER_H = 32;
    private static final int MIN_PANEL_W = 400;
    private static final int MAX_PANEL_W = 600;
    private static final int LIST_H = 220;
    private static final int HEADER_H = 60;
    private static final int ROW_BTN_W = 36;
    private static final int ROW_BTN_H = 18;
    private static final int PANEL_BG = -14013643;
    private static final int PANEL_BORDER = -12763318;
    private static final int LIST_BG = -14803162;
    private static final int ROW_HOVER = -13223862;
    private static final int BTN_BG = -12763318;
    private static final int BTN_DEL = -11913931;
    private int leftPos;
    private int topPos;
    private int panelW;
    private int panelH;
    private EditBox searchBox;
    private List<BossRespawnConfigClient.RuleEntry> filteredList = new ArrayList<BossRespawnConfigClient.RuleEntry>();
    private int scrollOffset;
    private String pendingDeleteId;
    private int visibleRows;

    public BossRespawnConfigScreen() {
        super((Component)Component.m_237115_((String)"gui.bosschongsheng.config.title"));
    }

    private void refreshFilter() {
        List<BossRespawnConfigClient.RuleEntry> all = BossRespawnConfigClient.getRuleList();
        String q = this.searchBox != null ? this.searchBox.m_94155_().toLowerCase(Locale.ROOT).trim() : "";
        this.filteredList = q.isEmpty() ? new ArrayList<BossRespawnConfigClient.RuleEntry>(all) : all.stream().filter(e -> e.structureId().toLowerCase(Locale.ROOT).contains(q) || BossRespawnConfigScreen.structureName(e.structureId()).toLowerCase(Locale.ROOT).contains(q) || e.triggerItemId().toLowerCase(Locale.ROOT).contains(q) || e.entityTypeId().toLowerCase(Locale.ROOT).contains(q) || BossRespawnConfigScreen.entityName(e.entityTypeId()).toLowerCase(Locale.ROOT).contains(q)).collect(Collectors.toList());
        this.scrollOffset = Math.min(this.scrollOffset, Math.max(0, this.filteredList.size() - this.visibleRows));
    }

    private static String structureName(String id) {
        return Component.m_237115_((String)("structure." + id.replace(":", "."))).getString();
    }

    private static String entityName(String id) {
        EntityType t = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)id));
        return t == null ? id : Component.m_237115_((String)t.m_20675_()).getString();
    }

    private static ItemStack itemStack(String itemId) {
        if (itemId == null || itemId.isEmpty()) {
            return new ItemStack((ItemLike)Items.f_42127_);
        }
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)itemId)));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.panelW = Math.min(600, Math.max(400, this.f_96543_ - 40));
        this.visibleRows = 9;
        this.panelH = 332;
        this.leftPos = (this.f_96543_ - this.panelW) / 2;
        this.topPos = (this.f_96544_ - this.panelH) / 2;
        BossRespawnConfigClient.clearError();
        XiangcaoNet.CHANNEL.sendToServer((Object)new PacketRequestConfig());
        this.searchBox = new EditBox(this.f_96547_, this.leftPos + 10, this.topPos + 20 + 10, this.panelW - 20, 20, (Component)Component.m_237113_((String)""));
        this.searchBox.m_257771_((Component)Component.m_237115_((String)"gui.bosschongsheng.config.search_hint"));
        this.searchBox.m_94151_(s -> this.refreshFilter());
        this.searchBox.m_94199_(64);
        this.m_142416_((GuiEventListener)this.searchBox);
        int btnY = this.topPos + this.panelH - 32 + 5;
        int bw = 52;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.bosschongsheng.config.add"), b -> this.f_96541_.m_91152_((Screen)new RulePickerScreen(this, null, null, null, false))).m_252987_(this.leftPos + 10, btnY, bw, 22).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.bosschongsheng.config.save"), b -> XiangcaoNet.CHANNEL.sendToServer((Object)new PacketSaveBossRules())).m_252987_(this.leftPos + 10 + bw + 6, btnY, bw, 22).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.bosschongsheng.config.reload"), b -> {
            XiangcaoNet.CHANNEL.sendToServer((Object)new PacketReloadBossRules());
            this.refreshFilter();
        }).m_252987_(this.leftPos + 10 + (bw + 6) * 2, btnY, bw, 22).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.bosschongsheng.config.close"), b -> this.m_7379_()).m_252987_(this.leftPos + this.panelW - 10 - 60, btnY, 60, 22).m_253136_());
    }

    public void m_86600_() {
        super.m_86600_();
        this.refreshFilter();
    }

    public void onRuleAddedOrEdited() {
        XiangcaoNet.CHANNEL.sendToServer((Object)new PacketRequestConfig());
        this.refreshFilter();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (mouseX >= (double)(this.leftPos + 10) && mouseX <= (double)(this.leftPos + this.panelW - 10) && mouseY >= (double)(this.topPos + 60) && mouseY <= (double)(this.topPos + 60 + 220)) {
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)(this.filteredList.size() - this.visibleRows), (double)this.scrollOffset - delta));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int idx;
        if (button != 0) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        int listTop = this.topPos + 60;
        int editX = this.leftPos + this.panelW - 10 - 72 - 8;
        int delX = this.leftPos + this.panelW - 10 - 36;
        for (int i = 0; i < this.visibleRows && (idx = this.scrollOffset + i) < this.filteredList.size(); ++i) {
            BossRespawnConfigClient.RuleEntry e = this.filteredList.get(idx);
            int rowY = listTop + i * 24;
            if (mouseY < (double)rowY || mouseY >= (double)(rowY + 24) || !(mouseX >= (double)(this.leftPos + 10)) || !(mouseX < (double)(this.leftPos + this.panelW - 10))) continue;
            if (e.structureId().equals(this.pendingDeleteId)) {
                if (mouseX >= (double)(this.leftPos + this.panelW - 10 - 72 - 8) && mouseX < (double)(this.leftPos + this.panelW - 10 - 36 - 8)) {
                    XiangcaoNet.CHANNEL.sendToServer((Object)new PacketRemoveBossRule(this.pendingDeleteId));
                    XiangcaoNet.CHANNEL.sendToServer((Object)new PacketRequestConfig());
                    this.pendingDeleteId = null;
                    this.refreshFilter();
                } else if (mouseX >= (double)delX && mouseX < (double)(delX + 36)) {
                    this.pendingDeleteId = null;
                }
            } else if (mouseX >= (double)delX && mouseX < (double)(delX + 36)) {
                this.pendingDeleteId = e.structureId();
            } else if (mouseX >= (double)editX && mouseX < (double)(editX + 36)) {
                this.f_96541_.m_91152_((Screen)new RulePickerScreen(this, e.structureId(), e.triggerItemId(), e.entityTypeId(), true));
            } else {
                this.f_96541_.m_91152_((Screen)new RulePickerScreen(this, e.structureId(), e.triggerItemId(), e.entityTypeId(), true));
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int idx;
        this.m_280273_(graphics);
        int x = this.leftPos;
        int y = this.topPos;
        graphics.m_280509_(x, y, x + this.panelW, y + this.panelH, -14013643);
        graphics.m_280509_(x, y, x + this.panelW, y + 1, -12763318);
        graphics.m_280509_(x, y + this.panelH - 1, x + this.panelW, y + this.panelH, -12763318);
        graphics.m_280509_(x, y, x + 1, y + this.panelH, -12763318);
        graphics.m_280509_(x + this.panelW - 1, y, x + this.panelW, y + this.panelH, -12763318);
        graphics.m_280614_(this.f_96547_, this.f_96539_, x + 10, y + 6, 0xF0F0F0, false);
        graphics.m_280509_(x + 10, y + 60 - 2, x + this.panelW - 10, y + 60 + 220 + 2, -14803162);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        int listTop = y + 60;
        int colStruct = x + 10 + 4;
        int colItem = colStruct + (this.panelW - 20) / 4;
        int colEntity = colItem + (this.panelW - 20) / 4;
        int editX = x + this.panelW - 10 - 72 - 8;
        int delX = x + this.panelW - 10 - 36;
        for (int i = 0; i < this.visibleRows && (idx = this.scrollOffset + i) < this.filteredList.size(); ++i) {
            Object struct;
            boolean hover;
            BossRespawnConfigClient.RuleEntry e = this.filteredList.get(idx);
            int rowY = listTop + i * 24;
            boolean bl = hover = mouseX >= x + 10 && mouseX < x + this.panelW - 10 && mouseY >= rowY && mouseY < rowY + 24;
            if (hover) {
                graphics.m_280509_(x + 10, rowY, x + this.panelW - 10, rowY + 24, -13223862);
            }
            if (this.f_96547_.m_92895_((String)(struct = BossRespawnConfigScreen.structureName(e.structureId()))) > colItem - colStruct - 8) {
                struct = this.f_96547_.m_92834_((String)struct, colItem - colStruct - 12) + "..";
            }
            graphics.m_280056_(this.f_96547_, (String)struct, colStruct, rowY + 8, 0xE0E0E0, false);
            ItemStack stack = BossRespawnConfigScreen.itemStack(e.triggerItemId());
            graphics.m_280480_(stack, colItem, rowY + 4);
            Object itemStr = stack.m_41786_().getString();
            if (this.f_96547_.m_92895_((String)itemStr) > colEntity - colItem - 24) {
                itemStr = this.f_96547_.m_92834_((String)itemStr, colEntity - colItem - 28) + "..";
            }
            graphics.m_280056_(this.f_96547_, (String)itemStr, colItem + 18, rowY + 8, 0xE0E0E0, false);
            Object ent = BossRespawnConfigScreen.entityName(e.entityTypeId());
            if (this.f_96547_.m_92895_((String)ent) > editX - colEntity - 8) {
                ent = this.f_96547_.m_92834_((String)ent, editX - colEntity - 12) + "..";
            }
            graphics.m_280056_(this.f_96547_, (String)ent, colEntity, rowY + 8, 0xB0B0B0, false);
            int btnY = rowY + 3;
            graphics.m_280509_(editX, btnY, editX + 36, btnY + 18, -12763318);
            graphics.m_280137_(this.f_96547_, Component.m_237115_((String)"gui.bosschongsheng.config.edit").getString(), editX + 18, btnY + 4, 0xE0E0E0);
            if (e.structureId().equals(this.pendingDeleteId)) {
                graphics.m_280509_(editX, btnY, editX + 36, btnY + 18, -13805011);
                graphics.m_280137_(this.f_96547_, Component.m_237115_((String)"gui.bosschongsheng.config.confirm").getString(), editX + 18, btnY + 4, 0xE0FFE0);
                graphics.m_280509_(delX, btnY, delX + 36, btnY + 18, -12763318);
                graphics.m_280137_(this.f_96547_, Component.m_237115_((String)"gui.cancel").getString(), delX + 18, btnY + 4, 0xE0E0E0);
                continue;
            }
            graphics.m_280509_(delX, btnY, delX + 36, btnY + 18, -11913931);
            graphics.m_280137_(this.f_96547_, Component.m_237115_((String)"gui.bosschongsheng.config.delete").getString(), delX + 18, btnY + 4, 0xFFAAAA);
        }
        String err = BossRespawnConfigClient.getLastError();
        if (err != null) {
            graphics.m_280056_(this.f_96547_, err, x + 10, y + this.panelH - 14, 0xFF6666, false);
        }
    }
}

